<?php

namespace Modules\ServiceHelper\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\ServiceHelper\app\Models\Discont;
use Modules\ServiceHelper\app\Http\Resources\DiscontResource;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Helpers\GenerateRandomString;
use App\Enums\DiscontStatus;

class DiscontApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $disconts = Discont::all();
        return sendResponse( DiscontResource::collection($disconts), 'Disconts retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = new Discont();
        $data->value = $request->value;
        $data->save();

        return sendResponse(new DiscontResource($data), 'Discont created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $discont = Discont::findOrFail($id);

        if (is_null($discont)) {

                return sendError(new DiscontResource($disconts), 'Discont not found, status false!');

            }elseif ( $disconts->status == 'activated') {

            return sendResponse(new DiscontResource($discont), 'Discont retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Discont $id)
    {
        $id->update($request->all());

        return  sendResponse(new DiscontResource($id), ' Discontupdated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $discont = Discont::find($id);
        $discont->delete($id);
        return  sendResponse([],'Discont deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id)
    {
        DB::table('disconts')
            ->where('id', $id)
            ->update(['status' => DiscontStatus::DEACTIVATED]);

        return  sendResponse(new DiscontResource($id), 'The size is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id)
    {
        DB::table('disconts')
            ->where('id', $id)
            ->update(['status' => DiscontStatus::ACTIVATED]);

        return  sendResponse(new DiscontResource($id), 'The size has been successfully activated.');
    }

}
