<?php

namespace Modules\ServiceHelper\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\ServiceHelper\app\Models\Size;
use Modules\ServiceHelper\app\Http\Resources\SizeResource;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Helpers\GenerateRandomString;
use App\Enums\SizeStatus;

class SizeApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $sizes = Size::all();
        
        return sendResponse(SizeResource::collection($sizes), 'Sizes retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = new Size();
        $data->name = $request->name;
        $data->alias = $request->alias;
        $data->save();

        return sendResponse(new SizeResource($data), 'Size created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $size = Size::findOrFail($id);

        if (is_null($size)) {

                return sendError(new SizeResource($size), 'Size not found, status false!');

            }elseif ( $size->status == 'activated') {

            return sendResponse(new SizeResource($size), 'Size retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Size $id)
    {
        $id->update($request->all());

        return  sendResponse(new SizeResource($id), 'Size updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $size = Size::find($id);
        $size->delete($id);
        return  sendResponse([],'Size deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id): JsonResponse
    {
        DB::table('sizes')
            ->where('id', $id)
            ->update(['status' => SizeStatus::DEACTIVATED]);

        return  sendResponse(new SizeResource($id), 'The size is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id)
    {
        DB::table('sizes')
            ->where('id', $id)
            ->update(['status' => SizeStatus::ACTIVATED]);

        return  sendResponse(new SizeResource($id), 'The size has been successfully activated.');
    }

}
