<?php

namespace Modules\ServiceHelper\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\ServiceHelper\Database\factories\CurrencyFactory;
use Modules\Products\app\Models\Product;

class Currency extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'currencies';
    
    protected $fillable = [
        'id',
        'name',
        'alias',
        'status',
    ];
    
    public function products(): HasMany
    {
        return $this->hasMany(Product::class);
    }
}
