<?php

namespace Modules\ServiceHelper\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\ServiceHelper\Database\factories\DiscontFactory;
use Modules\Products\Models\Product;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Discont extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table = 'disconts';
    
    protected $fillable = [
        'id',
        'value',
        'badge',
        'status',
        'product_id'
    ];
    
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
