<?php

namespace Modules\ServiceHelper\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\ServiceHelper\Database\factories\ImagesFactory;
use Modules\Category\Models\Category;
use Modules\Promotion\Models\Promotion;
use Modules\Products\Models\Product;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Livrason\app\Models\Livrason;
use Modules\Payments\app\Modules\PaymentGateway;

class Images extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $table ='images';
    
    protected $fillable = [
        'id',
        'api_server_path',
        'resource_folder',
        'resource_filename',
        'resource_alt_filename',
        'category_id',
        'promotion_id',
        'product_id',
        'livrason_id',
        'payment_gateway_id',
    ];
    
    public function promotion(): BelongsTo
    {
        return $this->belongsTo(Promotion::class);
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }
    
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
    public function livrason(): BelongsTo
    {
        return $this->belongsTo(Livrason::class);
    }
    public function payment_gateway(): BelongsTo
    {
        return $this->belongsTo(PaymentGateway::class);
    }
}
