<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\DiscontStatus;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('disconts', function (Blueprint $table) {
            $table->id();
            $table->float('value')->default(0);
            $table->string('badge')->default('%');
            $table->foreignId('product_id')->nullable()->constrained()->cascadeOnDelete();
            $table->enum('status', DiscontStatus::TYPES)->default(DiscontStatus::DEACTIVATED);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('disconts');
    }
};
