<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\ServiceHelper\App\Http\Controllers\Api\v1\CurrencyApiController;
use \Modules\ServiceHelper\App\Http\Controllers\Api\v1\SizeApiController;
use \Modules\ServiceHelper\App\Http\Controllers\Api\v1\BrendApiController;
use \Modules\ServiceHelper\App\Http\Controllers\Api\v1\DiscontApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== //

Route::middleware(['auth:api','administrator'])->group(function () {

    // ======================== currency api routes =============================== //

    Route::get('/currency',[CurrencyApiController::class,'index'])->name('currency.index');
    Route::get('/currency/{id}',[CurrencyApiController::class,'show'])->name('currency.show');
    Route::post('/currency',[CurrencyApiController::class,'store'])->name('currency.store');
    Route::put('/currency/{id}',[CurrencyApiController::class,'update'])->name('currency.update');
    Route::delete('/currency/{id}',[CurrencyApiController::class,'destroy'])->name('currency.destroy');
    Route::put('/currency/inactive/{id}',[CurrencyApiController::class,'inactive'])->name('currency.inactive');
    Route::put('/currency/active/{id}',[CurrencyApiController::class,'active'])->name('currency.active');

    // ======================== size api routes =============================== //
    
    Route::get('/size',[SizeApiController::class,'index'])->name('size.index');
    Route::get('/size/{id}',[SizeApiController::class,'show'])->name('size.show');
    Route::post('/size',[SizeApiController::class,'store'])->name('size.store');
    Route::put('/size/{id}',[SizeApiController::class,'update'])->name('size.update');
    Route::delete('/size/{id}',[SizeApiController::class,'destroy'])->name('size.destroy');
    Route::put('/size/inactive/{id}',[SizeApiController::class,'inactive'])->name('size.inactive');
    Route::put('/size/active/{id}',[SizeApiController::class,'active'])->name('size.active');
    // ======================== brend api routes =============================== //

    Route::get('/brend',[BrendApiController::class,'index'])->name('brend.index');
    Route::get('/brend/{id}',[BrendApiController::class,'show'])->name('brend.show');
    Route::post('/brend',[BrendApiController::class,'store'])->name('brend.store');
    Route::put('/brend/{id}',[BrendApiController::class,'update'])->name('brend.update');
    Route::delete('/brend/{id}',[BrendApiController::class,'destroy'])->name('brend.destroy');
    Route::put('/brend/inactive/{id}',[BrendApiController::class,'inactive'])->name('brend.inactive');
    Route::put('/brend/active/{id}',[BrendApiController::class,'active'])->name('brend.active');

    // ======================== discont api routes =============================== //

    Route::get('/discont',[DiscontApiController::class,'index'])->name('discont.index');
    Route::get('/discont/{id}',[DiscontApiController::class,'show'])->name('discont.show');
    Route::post('/discont',[DiscontApiController::class,'store'])->name('discont.store');
    Route::put('/discont/{id}',[DiscontApiController::class,'update'])->name('discont.update');
    Route::delete('/discont/{id}',[DiscontApiController::class,'destroy'])->name('discont.destroy');
    Route::put('/discont/inactive/{id}',[DiscontApiController::class,'inactive'])->name('discont.inactive'); 
    Route::put('/discont/active/{id}',[DiscontApiController::class,'active'])->name('discont.active');

});

