<?php

namespace Modules\Shares\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Shares\app\Models\Shares;
use Modules\Shares\app\Http\Resources\SharesResource;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Appp\Helpers\GenerateRandomString;
use App\Enums\SharesStatus;

class SharesApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $shares = Shares::all();
        return sendResponse(SharesResource::collection($shares), 'Shares retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = new Shares();
        $data->name = $request->name;
        $data->image= $request->image;
        $data->description = $request->description;
        $data->save();
        return sendResponse(new SharesResource($data), 'Shares created successfully.');
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $share = Shares::findOrFail($id);

        if (is_null($share)) {

                return sendError(new SharesResource($share), 'Shares not found, status false!');

            }elseif ( $share->status == 'activated') {

            return sendResponse(new SharesResource($share), 'Shares retrieved successfully, status true!');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Shares $id)
    {
        $id->update($request->all());

        return  sendResponse(new SharesResource($id), 'Shares updated successfully.');
    }

    /**
     * @param int $id
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $share = Shares::find($id);
        $share->delete($id);
        return  sendResponse([],'Shares deleted successfully.');
    }
    /**
     * Update the specified resource in storage.
     */
    public function inactive($id)
    {
        DB::table('shares')
            ->where('id', $id)
            ->update(['status' => SharesStatus::DEACTIVATED]);

        return  sendResponse(new SharesResource($id), 'The share is successfully deactivated.');
    }

    /**
     * Update the specified resource in storage.
     */

    public function active($id)
    {
        DB::table('shares')
            ->where('id', $id)
            ->update(['status' => SharesStatus::ACTIVATED]);

        return  sendResponse(new SharesResource($id), 'The share has been successfully activated.');
    }

}
