<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Shares\app\Http\Controllers\Api\v1\SharesApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

// ================ admin routes ======================== //

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::post('/shares',[SharesApiController::class,'store'])->name('shares.store');
    Route::put('/shares/{id}',[SharesApiController::class,'update'])->name('shares.update');
    Route::delete('/shares/{id}',[SharesApiController::class,'destroy'])->name('shares.destroy');
    Route::put('/shares/inactive/{id}',[SharesApiController::class,'inactive'])->name('shares.inactive');
    Route::put('/shares/active/{id}',[SharesApiController::class,'active'])->name('shares.active');
});

// ================= api routes ============== //

Route::middleware(['auth:api'])->group(function () {
    Route::get('/shares',[SharesApiController::class,'index'])->name('shares.index');
    Route::get('/shares/{id}',[SharesApiController::class,'show'])->name('shares.show');
    
});