<?php

namespace Modules\Taxes\app\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Taxes\app\Models\Tax;
use Modules\Taxes\app\Http\Resources\TaxResource;
use Modules\Taxes\app\Http\Requests\StoreTaxRequest;
use Appp\Helpers\ResponseHelper;
use App\Helpers\ResponseErrorHelper;
use Illuminate\Support\Facades\Validator;
use App\Helpers\GenerateRandomString;
use App\Enums\TaxStatus;

class TaxApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $taxes = Tax::all();
        return sendResponse(TaxResource::collection($taxes), 'Taxes retrieved successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = new Tax();
        $data->name = $request->name;
        $data->alias = $request->alias;
        $data->tax_value = $request->tax_value;
        $data->save();

        return sendResponse(new TaxResource($data), 'Tax created successfully.');
    }
    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Tax $id)
    {
        $id->update($request->all());
        return  sendResponse(new TaxResource($id), 'Tax updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $tax = Tax::find($id);
        $tax->delete($id);
        return  sendResponse([],'Tax deleted successfully.');
    }
}
