<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \Modules\Taxes\app\Http\Controllers\Api\v1\TaxApiController;
/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

Route::middleware(['auth:api','administrator'])->group(function () {
    Route::post('/tax',[TaxApiController::class,'store'])->name('tax.store');
    Route::put('/tax/{id}',[TaxApiController::class,'update'])->name('tax.update');
    Route::delete('/tax/{id}',[TaxApiController::class,'destroy'])->name('tax.destroy');
});

// ================= api routes ============== //

Route::middleware(['auth:api'])->group(function () {
    Route::get('/tax',[TaxApiController::class,'index'])->name('tax.index');
    Route::get('/tax/{id}',[TaxApiController::class,'show'])->name('tax.show');
    
});
