<?php
use Illuminate\Http\Request;
use Intervention\Image\ImageManager;

if (!function_exists('uploadMediumImage')) {
    /**
     * description
     *
     * @param
     * @return
     */
    function uploadImage(Request $request,$image)
    {
       
        $relPathOriginal = 'multimedia/uploads/images/products/original/';
        $relPathMedium = 'multimedia/uploads/images/products/medium/';
        $relPathMini = 'multimedia/uploads/images/products/mini/';

        if (!file_exists(public_path($relPathOriginal))) {
            mkdir(public_path($relPathOriginal), 777, true);
        }

        if (!file_exists(public_path($relPathMedium))) {
            mkdir(public_path($relPathMedium), 777, true);
        }

        if (!file_exists(public_path($relPathMini))) {
            mkdir(public_path($relPathMini), 777, true);
        }

        $filename = time() . '.' . $image->getClientOriginalName();
        (new \Intervention\Image\ImageManager)
            ->make($image)
            ->resize(300, 300)
            ->save($relPathOriginal . $filename);
        (new \Intervention\Image\ImageManager)
            ->make($image)
            ->resize(100, 100)
            ->save($relPathMedium . $filename);
        
        (new \Intervention\Image\ImageManager)
            ->make($image)
            ->resize(50, 50)
            ->save($relPathMini  . $filename);
            
        return $filename;
    }
}
