<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Appp\Helpers\ResponseHelper;
use Modules\Products\app\Models\Product;
use Modules\Products\app\Http\Resources\ProductResource;
use Modules\Category\app\Models\Category;
use Modules\Category\app\Http\Resources\CategoryResource;
use Modules\Orders\app\Models\Basket;
use Modules\Orders\app\Http\Resources\BasketResource;
use Modules\Livrason\app\Models\Livrason;
use Modules\Livrason\app\Http\Resources\LivrasonResource;
use Modules\Contact\app\Models\Contact;
use Modules\Contact\app\Http\Resources\ContactResource;
use Modules\Payments\app\Http\Resources\PaymentGatewayResource;
use Modules\Payments\app\Models\PaymentGateway;

class FrontendApiDataController extends Controller
{
    public function getFrontendContentData()
    {
        $products = Product::all();
        $categories = Category::all();
        $livrasons = Livrason::where('status','=','activated')->get();
        $baskets = Basket::all();
        $contacts = Contact::all();
        $paymentGateways = PaymentGateway::where('status','=','activated')->get();
        $data = [
            'categories' => CategoryResource::collection($categories),
            'products' => ProductResource::collection($products),
            'livrasons' => LivrasonResource::collection($livrasons),
            'contact' => ContactResource::collection($contacts),
            'basket'=> BasketResource::collection($baskets),
            'payment_gateway' => PaymentGatewayResource::collection($paymentGateways)
        ];
        return sendResponse($data, 'Datas retrieved successfully.');
    }
}
