<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Appp\Helpers\ResponseHelper;
// Models
use Modules\Category\app\Models\Category;
use Modules\Contact\app\Models\Contact;
use Modules\Delivery\app\Models\Delivery;
use Modules\Department\app\Models\Department;
use Modules\Invoices\app\Models\Invoice;
use Modules\Livrason\app\Models\Livrason;
use Modules\Messager\app\Models\Messager;
use Modules\Notification\app\Models\Notification;
use Modules\Orders\app\Models\Order;
use Modules\Payments\app\Models\Payment;
use Modules\Payments\app\Models\PaymentGateway;
use Modules\Products\app\Models\Product;
use Modules\Promotion\app\Models\Promotion;
use Modules\ServiceHelper\app\Models\Brend;
use Modules\ServiceHelper\app\Models\Currency;
use Modules\ServiceHelper\app\Models\Discont;
use Modules\ServiceHelper\app\Models\Size;
use Modules\Shares\app\Models\Shares;
use Modules\Taxes\app\Models\Tax;
use App\Models\User;
//Resourses
use Modules\Category\app\Http\Resources\CategoryResource;
use Modules\Contact\app\Http\Resources\ContactResource;
use Modules\Delivery\app\Http\Resources\DeliveryResource;
use Modules\Department\app\Http\Resources\DepartmentResource;
use Modules\Invoices\app\Http\Resources\InvoiceResource;
use Modules\Livrason\app\Http\Resources\LivrasonResource;
use Modules\Messager\app\Http\Resources\MessagerResource;
use Modules\Notification\app\Http\Resources\NotificationResource;
use Modules\Orders\app\Http\Resources\OrderResource;
use Modules\Payments\app\Http\Resources\PaymentResource;
use Modules\Payments\app\Http\Resources\PaymentGatewayResource;
use Modules\Products\app\Http\Resources\ProductResource;
use Modules\Promotion\app\Http\Resources\PromotionResource;
use Modules\ServiceHelper\app\Http\Resources\BrendResource;
use Modules\ServiceHelper\app\Http\Resources\CurrencyResource;
use Modules\ServiceHelper\app\Http\Resources\DiscontResource;
use Modules\ServiceHelper\app\Http\Resources\SizeResource;
use Modules\Shares\app\Http\Resources\SharesResource;
use Modules\Taxes\app\Http\Resources\TaxResource;
use App\Http\Resources\UserResource;

class PanelApiDataController extends Controller
{
    public function getPanelContentData()
    {   
        // ================ active data =============================== //

        $actived_categories = Category::where('status','=','activated')->get();//ok
        $delivery_inprogress = Delivery::where('status','=','in_processing')->get();//ok
        $delivery_sent = Delivery::where('status','=','sent')->get();//ok
        $delivery_fail = Delivery::where('status','=','fail')->get();//ok
        $actived_departments = Department::where('status','=','activated')->get();//ok
        $invoices_inprogress = Invoice::where('status','=','in_processing')->get();//ok
        $invoices_success = Invoice::where('status','=','success')->get();//ok???
        $invoices_fail = Invoice::where('status','=','fail')->get();//ok??
        $actived_livrasons = Livrason::where('status','=','activated')->get();//ok
        $reviewed_messages = Messager::where('status','=','reviewed')->get();//ok
        $not_reviewed_messages = Messager::where('status','=','not_reviewed')->get();//ok
        $reviewed_notifications = Notification::where('status','=','reviewed')->get();//ok
        $not_reviewed_notifications = Notification::where('status','=','not_reviewed')->get();//ok
        $orders_inprogress = Order::where('status','=','in_processing')->get();//ok
        $orders_success = Order::where('status','=','success')->get();//ok
        $orders_fail = Order::where('status','=','fail')->get();//ok
        $payments_inprogress = Payment::where('status','=','in_processing')->get();//ok
        $payments_success = Payment::where('status','=','success')->get();//ok
        $payments_fail = Payment::where('status','=','fail')->get();//ok
        $actived_payment_gateways = PaymentGateway::where('status','=','activated')->get();//ok
        $available_products = Product:: where('availability_status','=','available')->get();//ok
        $not_available_products = Product:: where('availability_status','=','not_available')->get();//ok
        $actived_promotions = Promotion::where('status','=','activated')->get();//ok
        $actived_taxes = Tax::where('status','=','activated')->get();//ok
        $actived_brends = Brend::where('status','=','activated')->get();//ok
        $actived_currencies = Currency::where('status','=','activated')->get();//ok
        $actived_disconts = Discont::where('status','=','activated')->get();//ok
        $actived_sizes = Size::where('status','=','activated')->get();//ok
        $actived_shares = Shares::where('status','=','activated')->get();//ok

        $data = [

            // all data

            'categories' => CategoryResource::collection(Category::all()),
            'contacts'  => ContactResource::collection(Contact::all()),
            'deliveries' => DeliveryResource::collection(Delivery::all()),
            'departments' => DepartmentResource::collection(Department::all()),
            'invoices' => InvoiceResource::collection(Invoice::all()),
            'livrasons' => LivrasonResource::collection(Livrason::all()),
            'messages' => MessagerResource::collection(Messager::all()),
            'notifications' => NotificationResource::collection(Notification::all()),
            'orders' => OrderResource::collection(Order::all()),
            'payments' => PaymentResource::collection(Payment::all()),
            'payment_gateway' => PaymentGatewayResource::collection(PaymentGateway::all()),
            'products' => ProductResource::collection(Product::all()), 
            'promotions'=> PromotionResource::collection(Promotion::all()),
            'taxes' => TaxResource::collection(Tax::all()),
            'brends' => BrendResource::collection(Brend::all()),
            'currencies' => CurrencyResource::collection(Currency::all()),
            'disconts' => DiscontResource::collection(Discont::all()),
            'sizes' => SizeResource::collection(Size::all()),
            'shares' => SharesResource::collection(Shares::all()),
            'users' => UserResource::collection(User::all()),
            // all active data

            'actived_categories' => CategoryResource::collection($actived_categories),//ok
            'delivery_inprogress' => DeliveryResource::collection($delivery_inprogress),
            'delivery_sent' => DeliveryResource::collection($delivery_sent),//ok
            'delivery_fail' => DeliveryResource::collection($delivery_fail),//ok
            'actived_departments' => DepartmentResource::collection($actived_departments),//ok
            'invoice_inprogress' => InvoiceResource::collection($invoices_inprogress),//ok
            'invoices_success' => InvoiceResource::collection($invoices_success),//ok
            'invoices_fail' => InvoiceResource::collection($invoices_fail),//ok
            'actived_livrasons' => LivrasonResource::collection($actived_livrasons),//ok
            'reviewed_messages' => MessagerResource::collection($reviewed_messages),//ok
            'not_reviewed_messages' => MessagerResource::collection($not_reviewed_messages),//ok
            'reviewed_notifications' => NotificationResource::collection($reviewed_notifications),//ok
            'not_reviewed_notifications' => NotificationResource::collection($not_reviewed_notifications),//ok
            'order_inprogress' => OrderResource::collection($orders_inprogress),//ok
            'order_success' => OrderResource::collection($orders_success),//ok
            'order_fail' => OrderResource::collection($orders_fail),//ok
            'payments_inprogress' => PaymentResource::collection($payments_inprogress),//ok
            'payments_success' => PaymentResource::collection($payments_success),//ok
            'payments_fail' => PaymentResource::collection($payments_fail),//ok
            'actived_payment_gateway' => PaymentGatewayResource::collection($actived_payment_gateways),//ok
            'available_products' => ProductResource::collection($available_products),//ok
            'not_available_products' => ProductResource::collection($not_available_products),//ok
            'actived_promotions'=> PromotionResource::collection($actived_promotions),//ok
            'actived_taxes' => TaxResource::collection($actived_taxes),//ok
            'actived_brends' => BrendResource::collection($actived_brends),//ok
            'actived_currencies' => CurrencyResource::collection($actived_currencies),//ok
            'actived_disconts' => DiscontResource::collection($actived_disconts),//ok
            'actived_sizes' => SizeResource::collection($actived_sizes),//ok
            'actived_shares' => SharesResource::collection($actived_shares),//ok
            
            // all data counter

            'messages_count' => Messager::where('status','=','not_reviewed')->count(),//ok
            'notifications_count' => Notification::where('status','=','not_reviewed')->count(),//ok
            'users_count' => User::where('role','=','client')->count(),//ok
            'orders_inprogress_count' => Order::where('status','=','in_processing')->count(),//ok
            'orders_success_count' => Order::where('status','=','success')->count(),//ok
            'orders_fail_count' => Order::where('status','=','fail')->count(),//ok
            'payments_inprogress_count' => Payment::where('status','=','in_processing')->count(),//ok
            'payments_success_count' => Payment::where('status','=','success')->count(),//ok
            'payments_fail_count' => Payment::where('status','=','fail')->count(),//ok
            'invoices_success_count' => Invoice::where('status','=','success')->count(),//ok
            'invoices_fail_count' => Invoice::where('status','=','fail')->count(),//ok
            'delivery_inprogress_count' => Delivery::where('status','=','in_processing')->count(),//ok
            'delivery_sent_count' => Delivery::where('status','=','fail')->count(),//ok
        ];
        return sendResponse($data, 'Datas retrieved successfully.');
    }
}
