<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\AuthService; 
use App\Helpers\AuthTokenGenerator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(AuthTokenGenerator::class, AuthService::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
